<?php

defined('PF_VERSION') OR exit('Access denied');

define('PLUGIN_CONTACTFORM', __('Contact Form', 'contactform'));

class Contactform_Plugin extends Pf_Plugin
{

    public $name = PLUGIN_CONTACTFORM;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is the contact form description';

    public function activate()
    {
        $db = Pf::database();
        $count = $db->dcount('*', 'pf_options', "`option_name`='contactform'");
        if ($count == 0) {
            $sql = "INSERT INTO `pf_options` ( `option_name`, `option_value`) VALUES ('contactform', '')";
            $db->query($sql);
        }
    }

    public function deactivate()
    {
        
    }

    public function admin_init()
    {
        require ABSPATH . '/includes/common/plugin/helpers/permission.php';
        if (plugin_check_acl(array(1, 2))) {
            $this->admin_menu('fa fa-inbox', __('Contact Forms', 'contactform'), 'contact-form', 'plugin_contactform_manager');
            $shortcode = Pf::shortcode();
            $shortcode->add('contactform', array($this, 'plugin_contactform_admin'));
        }
    }

    function plugin_contactform_manager()
    {

        $this->js('admin/themes/default/assets/bootstrap-notification/js/jquery/jquery.easing.1.3.js');
        $this->js('admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js');

        admin_css('plugins/contactform/assets/contactform.css');
        admin_css('plugins/contactform/assets/jquery-ui.min.css');
        admin_js('plugins/contactform/assets/bootbox.min.js');
        admin_js('plugins/contactform/assets/handlebars.min.js');
        admin_js('plugins/contactform/assets/jquery.selection.js');
        admin_js('includes/common/plugin/assets/base.js?t=95');
        admin_js('plugins/contactform/assets/contactform.js?t=' . uniqid());


        require_once ABSPATH . '/plugins/contactform/index.php';
    }

    //Public
    public function public_init()
    {
        $shortcode = Pf::shortcode();
        $shortcode->add('contactform', array($this, 'plugin_contactform_public'));
    }

    function plugin_contactform_public($atts, $content = null, $code = '')
    {
        $output = require ABSPATH . '/plugins/contactform/public/index.php';
        $output .= sc_build_form_item($atts);
        return $output;
    }

    function plugin_contactform_admin()
    {
        
    }

}
